/*
 * Examples  : Arduino Examples By....ETT CO.,LTD
 * Program   : SMS_Send
 * Software  : Arduino 1.6.0
 * Hardware  : ET-BASE AVR EASY32U4 + ET-3G UC15 
 * Function  : Send SMS to your phone number
 */
 
/* Not all pins on the Leonardo support change interrupts, 
 so only the following can be used for RX: 
 8, 9, 10, 11, 14 (MISO), 15 (SCK), 16 (MOSI).*/
 
#include <SoftwareSerial.h>

SoftwareSerial mySerial(10,11); // RX, TX
 
int led = 13;                          // LED D13
char phone_number[] = "XXXXXXXXXX";    // Your phone number  Example. 089xxxxxxx

void setup() 
{ 
  mySerial.begin(9600);                // Set RS232 9600 bps
  delay(5000);
  
  mySerial.print("AT+CMGF=1\r");       // Select SMS message format to text mode                 
  CheckOK();                           // Check "OK"
  
  mySerial.print("AT+CSMP=17,167,0,0\r");        // Set SMS Text Mode Parameters                 
  CheckOK();                                     // Check "OK" 
  
  mySerial.print("AT+CSCS=\"GSM\"\r");           // Select TE Character Set                
  CheckOK();                                     // Check "OK"

  mySerial.print("AT+CMGS=\"");                  // Send to your phone number          
  mySerial.print(phone_number);
  mySerial.print("\"\r");
 
  CheckReady();                                  // Check ">"
  mySerial.print("Hello from ET-3G UC15");       // SMS body    
  delay(100);
  mySerial.write(0x1A);                          // Ctrl+Z   
} 
  
void loop() 
{ 
  digitalWrite(led, HIGH);   
  delay(500);               
  digitalWrite(led, LOW);    
  delay(500);  
} 

void CheckOK()
{
  while(mySerial.read()!='K');          // Check "OK" 
  delay(100);  
}

void CheckReady()
{
  while(mySerial.read()!='>');          // Check ">" 
  delay(100);  
}
